/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.model;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelProperty;

public class RechiseledModelData {
    public static final ModelProperty<RechiseledModelData> PROPERTY = new ModelProperty();
    public Map<Direction, SideData> sides = Maps.newEnumMap(Direction.class);

    public static class SideData {
        public boolean left;
        public boolean right;
        public boolean up;
        public boolean up_left;
        public boolean up_right;
        public boolean down;
        public boolean down_left;
        public boolean down_right;

        public SideData(Direction side, Function<BlockPos, BlockState> blockGetter, BlockPos pos, Block block) {
            Direction down;
            Direction up;
            Direction right;
            Direction left;
            if (side.m_122434_() == Direction.Axis.Y) {
                left = Direction.WEST;
                right = Direction.EAST;
                up = side == Direction.UP ? Direction.NORTH : Direction.SOUTH;
                down = side == Direction.UP ? Direction.SOUTH : Direction.NORTH;
            } else {
                left = side.m_122427_();
                right = side.m_122428_();
                up = Direction.UP;
                down = Direction.DOWN;
            }
            this.left = SideData.isSameBlock(blockGetter, block, pos.m_142300_(left));
            this.right = SideData.isSameBlock(blockGetter, block, pos.m_142300_(right));
            this.up = SideData.isSameBlock(blockGetter, block, pos.m_142300_(up));
            this.up_left = SideData.isSameBlock(blockGetter, block, pos.m_142300_(up).m_142300_(left));
            this.up_right = SideData.isSameBlock(blockGetter, block, pos.m_142300_(up).m_142300_(right));
            this.down = SideData.isSameBlock(blockGetter, block, pos.m_142300_(down));
            this.down_left = SideData.isSameBlock(blockGetter, block, pos.m_142300_(down).m_142300_(left));
            this.down_right = SideData.isSameBlock(blockGetter, block, pos.m_142300_(down).m_142300_(right));
        }

        public SideData(Direction side, BlockGetter world, BlockPos pos, Block block) {
            this(side, arg_0 -> ((BlockGetter)world).m_8055_(arg_0), pos, block);
        }

        private static boolean isSameBlock(Function<BlockPos, BlockState> blockGetter, Block block, BlockPos pos) {
            return blockGetter.apply(pos).m_60734_() == block;
        }
    }
}

